%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%  GUI for different coordinate conversions


function varargout = cs2cs(varargin)
% CS2CS M-file for cs2cs.fig
%      CS2CS, by itself, creates a new CS2CS or raises the existing
%      singleton*.
%
%      H = CS2CS returns the handle to a new CS2CS or the handle to
%      the existing singleton*.
%
%      CS2CS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in CS2CS.M with the given input arguments.
%
%      CS2CS('Property','Value',...) creates a new CS2CS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before cs2cs_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to cs2cs_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help cs2cs

% Last Modified by GUIDE v2.5 28-May-2010 15:06:05

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @cs2cs_OpeningFcn, ...
                   'gui_OutputFcn',  @cs2cs_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT



% --- Executes just before cs2cs is made visible.
function cs2cs_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to cs2cs (see VARARGIN)

% Choose default command line output for cs2cs
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

set(0,'units','inches');
screensize = get(0,'screensize');
set(hObject,'units','inches','Position',[screensize(3)/2-(5.75/2),screensize(4)/2-(3.9375/2),5.75,3.9375]);

% UIWAIT makes cs2cs wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = cs2cs_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in popupmenu2.
function popupmenu2_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from
%        popupmenu2
switch get(handles.popupmenu2,'Value')   
    case 1
        set(handles.popupmenu4,'String',{'Spherical coordinate system'; 'Cylindrical coordinate system'});
        set(handles.text4,'String','X :');
        set(handles.text15,'String','Y :');
        set(handles.text16,'String','Z :');
    case 2
        set(handles.popupmenu4,'String',{'XYZ coordinate system'; 'Cylindrical coordinate system'});
        set(handles.text4,'String','r :');
        set(handles.text15,'String','theta:');
        set(handles.text16,'String','phi:');
    case 3
       set(handles.popupmenu4,'String',{'XYZ coordinate system';'Spherical coordinate system'});
       set(handles.text4,'String','rho :');
       set(handles.text15,'String','phi :');
       set(handles.text16,'String','z :');
    otherwise
end
set(handles.uipanel1,'Visible','on');
set(handles.uipanel2,'Visible','off');
global ready;
ready = [0 0 0];
global var;
var = [0 0 0];
set(handles.pushbutton1,'Enable','off');
set(handles.edit1,'String','');
set(handles.edit2,'String','');
set(handles.edit3,'String','');



% --- Executes during object creation, after setting all properties.
function popupmenu2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end;
global ready;
ready = [0 0 0];
global var;
var = [0 0 0];


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
global var;
m = get(handles.popupmenu2,'Value');
n = get(handles.popupmenu4,'Value');
[s1 s2 s3] = fromCS2CS(var, m ,n );
set(handles.text20,'String',num2str(s1));
set(handles.text21,'String',num2str(s2));
set(handles.text22,'String',num2str(s3));



function edit1_Callback(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit1 as text
%        str2double(get(hObject,'String')) returns contents of edit1 as a double
x = str2double(get(hObject,'String'));
global ready;
global var;
if (isnan(x));
    msgbox('Invalid input','Error');
    ready(1)= 0;
else
    ready(1)= 1;
    var(1) = x;
end;
if (ready == [1 1 1])
     set(handles.pushbutton1,'Enable','on');
 else
    set(handles.pushbutton1,'Enable','off'); 
end;

% --- Executes during object creation, after setting all properties.
function edit1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit2_Callback(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit2 as text
%        str2double(get(hObject,'String')) returns contents of edit2 as a double
x = str2double(get(hObject,'String')); 
global ready;
global var;
if (isnan(x));
    msgbox('Invalid input','Error');
    ready(2)= 0;
else
    ready(2)= 1;
    var(2) = x;
end;
if (ready == [1 1 1])
     set(handles.pushbutton1,'Enable','on');
else
     set(handles.pushbutton1,'Enable','off');
end;

% --- Executes during object creation, after setting all properties.
function edit2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double
x = str2double(get(hObject,'String')); 
global ready;
global var;
if (isnan(x));
    msgbox('Invalid input','Error');
    ready(3)= 0;
else
    ready(3)= 1;
    var(3) = x;
end;
if (ready == [1 1 1])
     set(handles.pushbutton1,'Enable','on');
else
     set(handles.pushbutton1,'Enable','off');
end;


% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu4.
function popupmenu4_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu4 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from
%        popupmenu4
set(handles.uipanel2,'Visible','on');
set(handles.pushbutton1,'Visible','on');
switch get(handles.popupmenu2,'Value')
    case 1
            switch get(handles.popupmenu4,'Value')
                case 1
                    set(handles.text17,'String','r :');
                    set(handles.text18,'String','theta:');
                    set(handles.text19,'String','phi:');
                case 2
                    set(handles.text17,'String','rho :');
                    set(handles.text18,'String','phi :');
                    set(handles.text19,'String','z :');
            end;
    case 2
            switch get(handles.popupmenu4,'Value')
                case 1
                    set(handles.text17,'String','X :');
                    set(handles.text18,'String','Y :');
                    set(handles.text19,'String','Z :');
                case 2
                    set(handles.text17,'String','rho :');
                    set(handles.text18,'String','phi :');
                    set(handles.text19,'String','z :');
            end;
    case 3
            switch get(handles.popupmenu4,'Value')
                case 1
                    set(handles.text17,'String','X :');
                    set(handles.text18,'String','Y :');
                    set(handles.text19,'String','Z :');
                case 2
                    set(handles.text17,'String','r :');
                    set(handles.text18,'String','theta:');
                    set(handles.text19,'String','phi:');
            end;
end;
global ready;
ready = [0 0 0];
global var;
var = [0 0 0];
set(handles.pushbutton1,'Enable','off');
set(handles.text20,'String','');
set(handles.text21,'String','');
set(handles.text22,'String','');
set(handles.edit1,'String','');
set(handles.edit2,'String','');
set(handles.edit3,'String','');




% --- Executes during object creation, after setting all properties.
function popupmenu4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function [s1 s2 s3] = fromCS2CS(var,m,n)
switch m
    case 1
            switch n
                case 1
                    [s1 s2 s3] = car2Sph(var(1),var(2),var(3));
                    s2 = s2 * 180/pi;
                    s3 = s3 *180/pi;
                case 2
                    [s1 s2 s3] = car2Cyl(var(1),var(2),var(3));
                     s2 = s2 * 180/pi;
            end;
    case 2
            var(2) = var(2)*pi/180;
            var(3) = var(3)*pi/180;
            switch n
                case 1
                    [s1 s2 s3] = sph2Car(var(1),var(2),var(3)); 
                case 2
                    [s1 s2 s3] = sph2Cyl(var(1),var(2),var(3));
                     s2 = s2 * 180/pi;
            end;
    case 3
            var(2) = var(2)*pi/180;
            switch n
                case 1
                    [s1 s2 s3] = cyl2Car(var(1),var(2),var(3));
                case 2
                    [s1 s2 s3] = cyl2Sph(var(1),var(2),var(3));
                    s2 = s2 * 180/pi;
                    s3 = s3 * 180/pi;
            end;
                        
end;
if (s1<0.00001)
    s1 = 0;
end;
if (s2<0.00001)
    s2 = 0;
end;
if (s3<0.00001)
    s3 = 0;
end;
